{* 
* @Module Name: AP Page Builder
* @Website: apollotheme.com - prestashop template provider
* @author Apollotheme <apollotheme@gmail.com>
* @copyright  2007-2016 Apollotheme
* @description: ApPageBuilder is module help you can build content for your shop
*}
<!-- @file modules\appagebuilder\views\templates\hook\ApCategoryImage -->
{function name=menu level=0}
<div class="item">
<ul class="level{$level}">
{foreach $data as $category}
	{if isset($category.children) && is_array($category.children)}
	<li class="cate_{$category.id_category}" >
		<a href="{$link->getCategoryLink($category.id_category, $category.link_rewrite)|escape:'html':'UTF-8'}">
			<span class="cate_content" {if {$category.id_category} == {$id_root}} style="display:none"{/if}>
				<span class="cover-img">
					{if isset($category.image)}
					<img src='{$category["image"]}' alt='{$category["name"]}' 
						 {if {$formAtts.showicons} == 0 || ({$level} gt 0 && {$formAtts.showicons} == 2)} style="display:none"{/if}/>
					{/if}
				</span>
				<label>{$category.name}</label>
			</span>
		</a>
		
		{menu data=$category.children level=$level+1}
	</li>
	{else}
	<li class="cate_{$category.id_category} text-center">
		<a href="{$link->getCategoryLink($category.id_category, $category.link_rewrite)|escape:'html':'UTF-8'}">
			{if isset($category.image)}
				<img class="img-responsive" src='{$category["image"]|escape:'html':'UTF-8'}' alt='{$category["name"]|escape:'html':'UTF-8'}' 
				 {if $formAtts.showicons == 0 || ($level gt 0 && $formAtts.showicons == 2)} style="display:none"{/if}/>
			{/if}
		</a>
		<div class="cate_content">
			<h4 class="title_block">
				<a href="{$link->getCategoryLink($category.id_category, $category.link_rewrite)|escape:'html':'UTF-8'}">
					{$category.name|escape:'html':'UTF-8'}
				</a>
			</h4>
			<span id="leo-cat-{$category.id_category}" class="leo-qty" data-str="{l s=' items' mod='appagebuilder'}" ></span>
		</div>
	</li>
	{/if}
{/foreach}
</ul>
</div>
{/function}

{if isset($categories)}
<div class="widget-category_image block">
	{$apLiveEdit}
	{if isset($formAtts.title) && !empty($formAtts.title)}
	<h4 class="title_block">
		{$formAtts.title}
	</h4>
	{/if}
	<div class="block_content">
		<div class="owl-row">
			<div class="owl-carousel owl-theme">
				{foreach from = $categories key=key item =cate}
					{menu data=$cate}
				{/foreach}
			</div>
		</div>
		 <div style="display:none">
		 			<span class ="view_all"><a href="javascript:void(0)">{l s='All Collection' mod='appagebuilder'}</a><span class="icon icon-arrow-right"> </span></span>
		 		</div>
	</div>
	{$apLiveEditEnd}
</div>
{/if}
<script type="text/javascript">
{literal}
	jQuery(document).ready(function() {
		var limit = {/literal}{$formAtts.limit}{literal};
		var level = {/literal}{$formAtts.cate_depth}{literal};
		$("ul.level0").each(function(){
			var element = $(this).find("ul.level" + level + " >li").length;
			var count = 0;
			$(this).find("ul.level" + level + " >li").each(function(){
			count = count + 1;
			if(count > limit){
				$(this).remove();
			}
			});

			if(element > limit){
				view = $(".view_all","#view_all_wapper").clone(1);
				view.appendTo($(this).find("ul.level" + level));
				var href = $(this).find('a:first').attr('href');
				$("a",view).attr("href", href);
			}
		});
	});
{/literal}
</script>